/****** Object:  StoredProcedure [dbo].[P_EST_NF_ENT_IT_REPROCESSAR_CUSTO]    Script Date: 09/25/2013 16:30:59 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_NF_ENT_IT_REPROCESSAR_CUSTO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_NF_ENT_IT_REPROCESSAR_CUSTO]
GO
GO
GO
--EXEC P_EST_NF_ENT_IT_REPROCESSAR_CUSTO 7,2015,10,0
CREATE PROCEDURE [dbo].[P_EST_NF_ENT_IT_REPROCESSAR_CUSTO]( @MES INT=NULL, 
														@ANO INT=NULL,
														@CD_FILIAL_PAR INT=0,
														@TIPO_CUSTO INT=0,
														@DT_PROC DATETIME=NULL,
														@CD_PROD INT=0)  WITH ENCRYPTION AS
	
	DECLARE @DT_INI DATETIME
	DECLARE @DT_FIM DATETIME
	DECLARE @DIA DATETIME
	DECLARE @CD_FILIAL AS INT
	DECLARE @AGORA DATETIME
	DECLARE @DT_LIMITE DATETIME
	DECLARE @NaoUtilizaCustoGerTransf Tinyint=0;

	--Rodar ate hoje
	SET @DT_LIMITE =(  SELECT CONVERT(VARCHAR,GETDATE(),112));

	SET NOCOUNT ON
	IF  @DT_PROC IS NULL
		begin
			IF @ANO IS NULL OR @MES IS NULL
				begin
					SELECT @AGORA=DATEADD(month, -1, GETDATE()), @ANO=YEAR(@AGORA), @MES=MONTH(@AGORA)
				end
			
			SET @DT_INI = CONVERT(DATETIME, (CONVERT(VARCHAR, (@ANO*100+@MES)) + '01')) ;
			SET @DT_FIM = dbo.F_FINAL_MES (@DT_INI) ;
		end
		
	IF  NOT @DT_PROC IS NULL
		begin
			SET @DT_INI = @DT_PROC;
			SET @DT_FIM = @DT_PROC;
		end 

		
/*************************************************************************************************/

 
IF  OBJECT_ID('TEMPDB.DBO.#RsProdNfEnt') IS NOT NULL
	BEGIN
		 DROP TABLE #RsProdNfEnt
	END
	 
	CREATE TABLE #RsProdNfEnt(CD_EMP INT,
								CD_FILIAL INT,
								CD_PROD INT )  

/*************************************************************************************************/

	DECLARE @NMTBL VARCHAR(100), @CMD VARCHAR(500);
	SET @NMTBL = 'EST_FECHA_PROC_MOV_PEND_TBL_PROC_' +CONVERT(VARCHAR,@CD_FILIAL_PAR);

	IF NOT OBJECT_ID(@NMTBL) IS NULL
	BEGIN 
		SET @CMD = 'INSERT INTO #RsProdNfEnt(CD_EMP, CD_FILIAL, CD_PROD)
					SELECT  DISTINCT CD_EMP, CD_FILIAL, CD_PROD
					FROM ' + @NMTBL + ' WHERE CD_EMP=1 '  
		SET @CMD = @CMD+ 'AND CD_FILIAL =' + convert(varchar,@CD_FILIAL_PAR) 
		
		IF NOT @DT_PROC  IS NULL
			SET @CMD = @CMD+ ' AND DT_PROC =''' + convert(varchar,@DT_PROC,112)  + ''''
			
		EXEC (@CMD);
	END 

	IF @CD_PROD > 0 
	BEGIN
		delete from #RsProdNfEnt
		INSERT INTO #RsProdNfEnt(CD_EMP, CD_FILIAL, CD_PROD)
		SELECT 1, @CD_FILIAL_PAR, @CD_PROD
	END 

	if not exists(select top 1 cd_emp from #RsProdNfEnt)
	begin
		INSERT INTO #RSPRODNFENT(CD_EMP, CD_FILIAL, CD_PROD)
		SELECT DISTINCT CD_EMP, CD_FILIAL, CD_PROD
		FROM 
			EST_NF_ENT_IT
		WHERE
			EST_NF_ENT_IT.CD_EMP = 1 
			AND EST_NF_ENT_IT.CD_FILIAL =CASE WHEN @CD_FILIAL_PAR = 0 THEN CD_FILIAL ELSE @CD_FILIAL_PAR END
			AND EST_NF_ENT_IT.DT_ENT BETWEEN @DT_INI AND @DT_FIM
	end


	SEt @NaoUtilizaCustoGerTransf = ISNULL ((SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_CHAVE = 'NAO_CONTROLA_CUSTO_GERENCIAL_TRANSF'),0)
/*************************************************************************************************/ 
	--Atualiza ate hoje...
	IF  @DT_FIM > @DT_LIMITE  
	BEGIN
		SET @DT_FIM = @DT_LIMITE
	END
	PRINT 'Custo do movimento de entrada  ' + CONVERT(VARCHAR, GETDATE (),108)
					
	DECLARE cFilialNFCusto CURSOR FAST_FORWARD READ_ONLY FOR 
	SELECT  
	 	CD_FILIAL
	FROM 
		PRC_FILIAL
	WHERE 
		CD_EMP = 1  
		AND CD_FILIAL = CASE WHEN @CD_FILIAL_PAR = 0 THEN CD_FILIAL ELSE @CD_FILIAL_PAR END
	OPEN cFilialNFCusto
	FETCH NEXT FROM cFilialNFCusto INTO @CD_FILIAL

	WHILE @@FETCH_STATUS=0
	BEGIN
		SET @DIA = @DT_INI
		WHILE @DT_FIM >= @DIA
			BEGIN
				PRINT 'Filial ' + CONVERT(VARCHAR, @CD_FILIAL) + ' -  Processando dia  ' + CONVERT(VARCHAR, @DIA, 112) + ' ' + CONVERT(VARCHAR, GETDATE (),108)
				begin
					UPDATE
						EST_NF_ENT_IT
					SET 
						VLR_CUSTO_MD = dbo.F_VLR_CUSTO_EST_FECHA_PROC_MOV (EST_NF_ENT_IT.CD_EMP,EST_NF_ENT_IT.CD_FILIAL,EST_NF_ENT_IT.CD_PROD,EST_NF_ENT_IT.DT_ENT,0),
						VLR_CUSTO_GERENCIAL_TRANSF=Case When @NaoUtilizaCustoGerTransf = 0 then	
																dbo.F_VLR_CUSTO_EST_FECHA_PROC_MOV (EST_NF_ENT_IT.CD_EMP,ISNULL(EST_NF_ENT_EST_NF_SAI_TRANSF.CD_FIL_ORIG,-1),EST_NF_ENT_IT.CD_PROD,EST_NF_ENT.DT_EMI_NF,1) 
															else VLR_CUSTO_MD end
					FROM
						EST_NF_ENT_IT INNER JOIN EST_NF_ENT ON
						EST_NF_ENT_IT.CD_EMP = EST_NF_ENT.CD_EMP AND
						EST_NF_ENT_IT.CD_FILIAL = EST_NF_ENT.CD_FILIAL AND
						EST_NF_ENT_IT.CD_NF = EST_NF_ENT.CD_NF
						LEFT OUTER JOIN EST_NF_ENT_EST_NF_SAI_TRANSF ON
						EST_NF_ENT_IT.CD_EMP = EST_NF_ENT_EST_NF_SAI_TRANSF.CD_EMP AND
						EST_NF_ENT_IT.CD_FILIAL = EST_NF_ENT_EST_NF_SAI_TRANSF.CD_FIL_DEST AND
						EST_NF_ENT_IT.CD_NF = EST_NF_ENT_EST_NF_SAI_TRANSF.CD_NF_ENT
						INNER JOIN #RsProdNfEnt E ON
						EST_NF_ENT_IT.CD_EMP = E.CD_EMP AND
						EST_NF_ENT_IT.CD_FILIAL = E.CD_FILIAL AND
						EST_NF_ENT_IT.CD_PROD = E.CD_PROD

					WHERE
						EST_NF_ENT_IT.CD_EMP = 1 
						AND EST_NF_ENT_IT.CD_FILIAL = @CD_FILIAL 
						AND EST_NF_ENT_IT.DT_ENT = @DIA 	
				end					
				SELECT @DIA = @DIA + 1
			END		
		FETCH NEXT FROM  cFilialNFCusto INTO @CD_FILIAL 
	END
CLOSE cFilialNFCusto
DEALLOCATE cFilialNFCusto

